REM File Size Alert
REM Alerts when the given file becomes larger than specified critical size
REM If size is smaller than critical value, writes it to log
REM FileToBeChecked is path to the file to be checked
REM LogName is name of the log file (without extension)
REM CriticalSize is critical value of sizt of the specified file (in bytes)
@ECHO off
SET FileToBeChecked=
SET CriticalSize=
SET LogName=SizeLog
FOR %%I in (%FileToBeChecked%) do SET sof=%%~zI
IF %sof% lss %CriticalSize%   GOTO stat
ECHO Size of file %FileToBeChecked% is larger than critical value (actual size: %sof%)
PAUSE
GOTO :EOF
:stat
for /f "tokens=2,3,4 delims=. " %%I in ('date /t') do set dd=%%I& set mm=%%J& set gg=%%K
FOR /f %%I in ('time /t') do SET tm=%%I
IF %dd%%mm%==3112   REN %LogName%.txt %LogName%%gg%.txt
ECHO %dd%.%mm%.%gg% %tm% %sof% >> %LogName%.txt
